<?php
/******************************************************************************
  Formulaire d'envoi de mail au webmaster
  // Introdurre funzione di sicurezza per controllare che l'invio avvenga dal sito
******************************************************************************/

/***
	Fork CréaSite
***/


if ($cfg['ext_antispam']) {
   require_once(PATH."extensions/antispam/".$cfg['ext_antispam']."/extension".INCEXT);
   if (SpamCheck(USER_IP)) {
      include(PATH.'error.php');
      die();
   }
}
require_once(PATH."extensions/captcha/".$cfg['ext_captcha']."/extension".INCEXT);
require_once(PATH."modules/contact/lang/".USER_LANG."_txt_public".INCEXT);
$cfg_contact = ReadCSVPairs(PATH_DAT."contact/config".DBEXT);
$wmlfrmCaptcha = (USER_IN === true) ? $cfg_contact['showcaptcha'] : CaptchaTest();
// Initialisation des variables
if (USER_IN===false) {
   $wmlfrmNomExp = isset($_POST['name']) ? decode_gpc($_POST['name']) : '';
   $wmlfrmAdrEmailExp = isset($_POST['mail']) ? decode_gpc($_POST['mail']) : '';
} else {
   $wmlfrmNomExp = USER_NAME;
   if ($cfg['multiuser']) {
      $user = ReadCSVPairs(PATH_DAT."users/profile/".USER_ID.DBEXT);
      $wmlfrmAdrEmailExp = $user['mail'];      
   } else {$wmlfrmAdrEmailExp = $cfg['site_mail']; }
}
$wmlfrmMessageExp = isset($_POST['message']) ? decode_gpc($_POST['message']) : '';
$wmlfrmEnvoyer = isset($_POST['send']) ? decode_gpc($_POST['send']) : '';
$wmlfrmForm = "";
$wmlfrmErreur = 0;
$wmlfrmNomExp = trim($wmlfrmNomExp);
$wmlfrmAdrEmailExp = trim($wmlfrmAdrEmailExp);
$wmlfrmMessageExp = trim($wmlfrmMessageExp);
if ($cfg_contact['privacy'] && (USER_IN===false)) $wmlfrmAccept = (!isset($_POST['accept']) || ($_POST['accept'] == false)) ? false : true;
if ($wmlfrmEnvoyer == 1) {
	// Vérification du nom et du message
	if ($wmlfrmNomExp and $wmlfrmMessageExp) {
		// Vérification de l'adresse email (si non vide)
		if (!empty($wmlfrmAdrEmailExp) and MailVerify($wmlfrmAdrEmailExp)) {
			// Vérification du spam
			if ($cfg['ext_antispam']) {
            if (SpamCheck('', $wmlfrmAdrEmailExp)) $wmlfrmErreur = 2;
         }
			// Vérification du code du cryptogramme
			if ($wmlfrmCaptcha && !CaptchaVerify()) $wmlfrmErreur = 4;
         if (isset ($wmlfrmAccept) && ($wmlfrmAccept == false)) $wmlfrmErreur = 5;
		} else $wmlfrmErreur = 2;
	} else $wmlfrmErreur = 1;
	if ($wmlfrmErreur == 0) {
		// Envoi du mail (au format texte brut)
		require_once(PATH."extensions/mail/".$cfg['ext_mail']."/extension".INCEXT);
		$email = trim($cfg['site_mail']);
		$subject = $msg_pub['message_from_site']." ".$cfg['title_'.USER_LANG];
		$from = 'From: contacts@'.$cfg['site_url']."\r\n";
		$message = $msg_pub['sent_by'].": ".$wmlfrmNomExp."\n";
		if (!empty($wmlfrmAdrEmailExp)) $message .= $msg_pub['mail_adress'].": ".$wmlfrmAdrEmailExp."\n";
		$message .= $msg_pub['ip_address'].": ".USER_IP."\n";
		$message .= "\n".$wmlfrmMessageExp;
		$message = wordwrap($message, 70);
		if (MailSend ($email, $subject, $message, $from, $addheaders)) $wmlfrmForm = 1;  // OK
	}
}
//=============================================================================
//                          Affichage de la page
//=============================================================================
$meta['title'] = $cfg_contact['meta_tit_'.USER_LANG];
$meta['description'] = $cfg_contact['meta_des_'.USER_LANG];;
if (empty($wmlfrmForm)) {   // Formulaire d'envoi de message
   if ($wmlfrmErreur) {
		$messagesErreur = array(
			1 => $msg_pub['error1'],
			2 => $msg_pub['error2'],
			3 => $msg_pub['error3'],
			4 => $msg_pub['captcha_failed'],
			5 => $msg_pub['accept_failed']
		);
      $footjs[] = '<script src="'.PATH_LNK.'include/js/notifIt.min.js"></script>';
      $headcss[] = '<link rel="stylesheet" href="'.PATH_LNK.'include/js/notifIt.css">';

	// Affichage du message d'erreur
      $footjs[] ='<script>
         notif({
         type: "error",
         msg: "'.$messagesErreur[$wmlfrmErreur].'",
         width: "all",
         position: "center",
         opacity: "0.9",
         autohide: false
      });
   </script>
   ';
   }
   include PATH."include/hpage.inc";
   htable($meta['title'], "100%");
   echo '<div class="w'.$cfg_contact['width'].'" style="float:none">'.PHP_EOL;
   echo '<form action="'.$_SERVER['SCRIPT_NAME'].'#message" method="post" accept-charset="'.CHARSET.'">
   <input type="hidden" name="send" value="1" />
   ';
   $disabled = (USER_IN === true) ? " disabled" : "";
   if ($cfg_contact['info_txt_'.USER_LANG])
      echo '<div><p>'.$cfg_contact['info_txt_'.USER_LANG]."</p>\n";
   echo '
<form>
<div class="form-group">
<label for="formGroupExampleInput">'.$msg_pub['your_name'].'</label>
<input class="form-control" type="text" name="name" size="40" maxlength="40" value="'.conv_html($wmlfrmNomExp).'"'.$disabled.' />
</div>
<div class="form-group">
<label>'.$msg_pub['mail_adress'].'</label>
<input class="form-control" type="text" name="mail" size="40" maxlength="40" value="'.conv_html($wmlfrmAdrEmailExp).'"'.$disabled.' />
</div>
<div class="form-group">
<label for="exampleFormControlTextarea1">'.$msg_pub['your_message'].'</label>
<textarea  class="form-control" cols="40" rows="10" name="message">'.conv_html($wmlfrmMessageExp).'</textarea>
</div>
    ';
   echo "</form>\n";
   if ($cfg_contact['privacy'] && USER_IN==false) {
      $checked = ($wmlfrmAccept) ? ' checked' : '';
      echo '<input type="checkbox" name="accept" id="privacy"'.$checked.'>';
      echo '<label for="privacy"> '.$msg_pub['privacy']."</label>\n";
   }
   if ($cfg_contact['policy'] && USER_IN==false) echo "<div>
   <br />".$msg_pub['policy']."</div>\n";
   if ($wmlfrmCaptcha) {
		echo '<div class="captcha">';
		echo  "<br />\n";
    CaptchaDisplay();
		echo '<br />
         </div>';
  }
   ?><br />
         <div class="btn-group">
               <input class="btn btn-outline-success" type="submit" value="<?php echo $msg_pub['submit']; ?>" />
         </div>
  </form>
  </div>
   <?php
}
elseif ($wmlfrmForm == 1) {   // Message de confirmation d'envoi réussi
   include(PATH."include/hpage.inc");
   htable($meta['title'], "100%");
  echo '
  <p>&nbsp;<br />
  <strong>'.$msg_pub['send_ok'].'</strong>
  <br />&nbsp;</p>
  ';
}
if (USER_LEVEL > 4) {
   echo '<div class="quick-links">
<a href="'.PATH_LNK.'admin/panel.php?pg=contact"><img src="'.PATH_LNK.'include/ico/pen_sqr.png" width="16" height="16" border="0" alt="'.$msg_pub['admin'].'" title="'.$msg_pub['admin'].'" /></a>
</div>
';
}
btable();
include("include/bpage.inc");
?>